/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.security;

import com.ibm.net.ssl.SSLContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.snia.wbemcmd.xml.SocketProvider;

public class PKCS12SocketProvider
extends SocketProvider {
    private static SSLSocketFactory sf;
    private static SSLServerSocketFactory ssf;
    private static boolean isValid;

    void assertValidity() throws IOException {
        if (!isValid) {
            throw new IOException("SSL Socket Factory Initialization Failed");
        }
    }

    public String getHTTPType() {
        return "https";
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        this.assertValidity();
        return sf.createSocket(inetAddress, n);
    }

    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        this.assertValidity();
        return ssf.createServerSocket(n, n2);
    }

    public Socket createSocketWrapper(Socket socket, String string, int n) throws IOException {
        this.assertValidity();
        return sf.createSocket(socket, string, n, true);
    }

    static {
        isValid = true;
        try {
            String string = System.getProperty("javax.net.ssl.keyStore");
            String string2 = System.getProperty("javax.net.ssl.keyStorePassword");
            SSLContext sSLContext = SSLContext.getInstance((String)"SSL");
            sSLContext.init("PKCS#12", string, string2);
            sf = sSLContext.getSocketFactory();
            ssf = sSLContext.getServerSocketFactory();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            isValid = false;
        }
    }
}

